/*
                           ....::::: In The Name Of GOD :::::....

    TFT LCD (ILI9325-ILI9320 LCD Driver) Functions
    By Armin Ghani     2009/12/18 

    Important Note :
	DO NOT Change LCD Register Definitions And LCD Command Codes 
*/

#ifndef _TFTLCD_FUNCTIONS_H_
#define _TFTLCD_FUNCTIONS_H_
 
/* LCD Pin Register Definitions */
#ifdef TFTLCD_DATAPORT_A
	#define _TFTLCD_DATAPORT_ID_	   AT91C_ID_PIOA
	#define _TFTLCD_DATAPORT_PER_	   *AT91C_PIOA_PER
	#define _TFTLCD_DATAPORT_PDR_	   *AT91C_PIOA_PDR
	#define _TFTLCD_DATAPORT_OER_	   *AT91C_PIOA_OER
	#define _TFTLCD_DATAPORT_ODR_	   *AT91C_PIOA_ODR
	#define _TFTLCD_DATAPORT_PUER_	   *AT91C_PIOA_PPUER
	#define _TFTLCD_DATAPORT_PUDR_	   *AT91C_PIOA_PPUDR
	#define _TFTLCD_DATAPORT_PDSR_	   *AT91C_PIOA_PDSR
	#define _TFTLCD_DATAPORT_SODR_	   *AT91C_PIOA_SODR
	#define _TFTLCD_DATAPORT_CODR_	   *AT91C_PIOA_CODR
#endif
#ifdef TFTLCD_DATAPORT_B
	#define _TFTLCD_DATAPORT_ID_	   AT91C_ID_PIOB
	#define _TFTLCD_DATAPORT_PER_	   *AT91C_PIOB_PER
	#define _TFTLCD_DATAPORT_PDR_	   *AT91C_PIOB_PDR
	#define _TFTLCD_DATAPORT_OER_	   *AT91C_PIOB_OER
	#define _TFTLCD_DATAPORT_ODR_	   *AT91C_PIOB_ODR
	#define _TFTLCD_DATAPORT_PUER_	   *AT91C_PIOB_PPUER
	#define _TFTLCD_DATAPORT_PUDR_	   *AT91C_PIOB_PPUDR
	#define _TFTLCD_DATAPORT_PDSR_	   *AT91C_PIOB_PDSR
	#define _TFTLCD_DATAPORT_SODR_	   *AT91C_PIOB_SODR
	#define _TFTLCD_DATAPORT_CODR_	   *AT91C_PIOB_CODR
#endif

#ifdef TFTLCD_CONTROLPORT_A
	#define _TFTLCD_CONTROLPORT_ID_	       AT91C_ID_PIOA
	#define _TFTLCD_CONTROLPORT_PER_	   *AT91C_PIOA_PER
	#define _TFTLCD_CONTROLPORT_PDR_	   *AT91C_PIOA_PDR
	#define _TFTLCD_CONTROLPORT_OER_	   *AT91C_PIOA_OER
	#define _TFTLCD_CONTROLPORT_ODR_	   *AT91C_PIOA_ODR
	#define _TFTLCD_CONTROLPORT_PUER_	   *AT91C_PIOA_PPUER
	#define _TFTLCD_CONTROLPORT_PUDR_	   *AT91C_PIOA_PPUDR
	#define _TFTLCD_CONTROLPORT_SODR_	   *AT91C_PIOA_SODR
	#define _TFTLCD_CONTROLPORT_CODR_	   *AT91C_PIOA_CODR
#endif
#ifdef TFTLCD_CONTROLPORT_B
	#define _TFTLCD_CONTROLPORT_ID_	       AT91C_ID_PIOB
	#define _TFTLCD_CONTROLPORT_PER_	   *AT91C_PIOB_PER
	#define _TFTLCD_CONTROLPORT_PDR_	   *AT91C_PIOB_PDR
	#define _TFTLCD_CONTROLPORT_OER_	   *AT91C_PIOB_OER
	#define _TFTLCD_CONTROLPORT_ODR_	   *AT91C_PIOB_ODR
	#define _TFTLCD_CONTROLPORT_PUER_	   *AT91C_PIOB_PPUER
	#define _TFTLCD_CONTROLPORT_PUDR_	   *AT91C_PIOB_PPUDR
	#define _TFTLCD_CONTROLPORT_SODR_	   *AT91C_PIOB_SODR
	#define _TFTLCD_CONTROLPORT_CODR_	   *AT91C_PIOB_CODR
#endif

#define TFTLCD_RST_LOW                 _TFTLCD_CONTROLPORT_CODR_ = (1 << TFTLCD_RST)
#define TFTLCD_RST_HIGH                _TFTLCD_CONTROLPORT_SODR_ = (1 << TFTLCD_RST)
#define TFTLCD_RS_LOW                  _TFTLCD_CONTROLPORT_CODR_ = (1 << TFTLCD_RS)
#define TFTLCD_RS_HIGH                 _TFTLCD_CONTROLPORT_SODR_ = (1 << TFTLCD_RS)
#define TFTLCD_CS_LOW                  _TFTLCD_CONTROLPORT_CODR_ = (1 << TFTLCD_CS)
#define TFTLCD_CS_HIGH                 _TFTLCD_CONTROLPORT_SODR_ = (1 << TFTLCD_CS)			
#define TFTLCD_RD_LOW                  _TFTLCD_CONTROLPORT_CODR_ = (1 << TFTLCD_RD)
#define TFTLCD_RD_HIGH                 _TFTLCD_CONTROLPORT_SODR_ = (1 << TFTLCD_RD)
#define TFTLCD_WR_LOW                  _TFTLCD_CONTROLPORT_CODR_ = (1 << TFTLCD_WR)
#define TFTLCD_WR_HIGH                 _TFTLCD_CONTROLPORT_SODR_ = (1 << TFTLCD_WR)    
#define TFTLCD_DATAPORT_INPUT		   _TFTLCD_DATAPORT_ODR_ = (0xFFFF << TFTLCD_DATAPORT_OFFSET)
#define TFTLCD_DATAPORT_OUTPUT         _TFTLCD_DATAPORT_OER_ = (0xFFFF << TFTLCD_DATAPORT_OFFSET)                      
#define TFTLCD_DATAPORT_CLEAR          _TFTLCD_DATAPORT_CODR_ = (0xFFFF << TFTLCD_DATAPORT_OFFSET)

/* LCD Command Codes */
#define TS_INS_START_OSC            0x00
#define TS_INS_DRIV_OUT_CTRL        0x01
#define TS_INS_DRIV_WAV_CTRL        0x02
#define TS_INS_ENTRY_MOD            0x03
#define TS_INS_RESIZE_CTRL          0x04
#define TS_INS_DISP_CTRL1           0x07
#define TS_INS_DISP_CTRL2           0x08
#define TS_INS_DISP_CTRL3           0x09
#define TS_INS_DISP_CTRL4           0x0A
#define TS_INS_RGB_DISP_IF_CTRL1    0x0C
#define TS_INS_FRM_MARKER_POS       0x0D
#define TS_INS_RGB_DISP_IF_CTRL2    0x0F
#define TS_INS_POW_CTRL1            0x10
#define TS_INS_POW_CTRL2            0x11
#define TS_INS_POW_CTRL3            0x12
#define TS_INS_POW_CTRL4            0x13
#define TS_INS_GRAM_HOR_AD          0x20
#define TS_INS_GRAM_VER_AD          0x21
#define TS_INS_RW_GRAM              0x22
#define TS_INS_POW_CTRL7            0x29
#define TS_INS_FRM_RATE_COL_CTRL    0x2B
#define TS_INS_GAMMA_CTRL1          0x30
#define TS_INS_GAMMA_CTRL2          0x31
#define TS_INS_GAMMA_CTRL3          0x32
#define TS_INS_GAMMA_CTRL4          0x35 
#define TS_INS_GAMMA_CTRL5          0x36
#define TS_INS_GAMMA_CTRL6          0x37
#define TS_INS_GAMMA_CTRL7          0x38
#define TS_INS_GAMMA_CTRL8          0x39
#define TS_INS_GAMMA_CTRL9          0x3C
#define TS_INS_GAMMA_CTRL10         0x3D
#define TS_INS_HOR_START_AD         0x50
#define TS_INS_HOR_END_AD           0x51
#define TS_INS_VER_START_AD         0x52
#define TS_INS_VER_END_AD           0x53
#define TS_INS_GATE_SCAN_CTRL1      0x60
#define TS_INS_GATE_SCAN_CTRL2      0x61
#define TS_INS_GATE_SCAN_CTRL3      0x6A
#define TS_INS_PART_IMG1_DISP_POS   0x80
#define TS_INS_PART_IMG1_START_AD   0x81
#define TS_INS_PART_IMG1_END_AD     0x82
#define TS_INS_PART_IMG2_DISP_POS   0x83
#define TS_INS_PART_IMG2_START_AD   0x84
#define TS_INS_PART_IMG2_END_AD     0x85
#define TS_INS_PANEL_IF_CTRL1       0x90
#define TS_INS_PANEL_IF_CTRL2       0x92
#define TS_INS_PANEL_IF_CTRL3       0x93
#define TS_INS_PANEL_IF_CTRL4       0x95
#define TS_INS_PANEL_IF_CTRL5       0x97
#define TS_INS_PANEL_IF_CTRL6       0x98           

#ifdef PORTRAIT
#define TS_SIZE_X                   240
#define TS_SIZE_Y                   320
#define TS_VAL_ENTRY_MOD            0x0030
#define TS_INS_GRAM_ADX             TS_INS_GRAM_HOR_AD
#define TS_INS_GRAM_ADY             TS_INS_GRAM_VER_AD
#define TS_INS_START_ADX            TS_INS_HOR_START_AD
#define TS_INS_END_ADX              TS_INS_HOR_END_AD
#define TS_INS_START_ADY            TS_INS_VER_START_AD
#define TS_INS_END_ADY              TS_INS_VER_END_AD
#endif

#ifdef LANDSCAPE
#define TS_SIZE_X					320
#define TS_SIZE_Y					240
#define TS_VAL_ENTRY_MOD			0x0028
#define TS_INS_GRAM_ADX				TS_INS_GRAM_VER_AD
#define TS_INS_GRAM_ADY				TS_INS_GRAM_HOR_AD
#define TS_INS_START_ADX   			TS_INS_VER_START_AD
#define TS_INS_END_ADX   			TS_INS_VER_END_AD
#define TS_INS_START_ADY   			TS_INS_HOR_START_AD
#define TS_INS_END_ADY   			TS_INS_HOR_END_AD
#endif

#define RED                         0x001F
#define GREEN                       0x07E0
#define BLUE                        0xF800
#define YELLOW                      0x07FF
#define PURPLE                      0xF81F
#define BLACK                       0x0000
#define WHITE                       0xFFFF

#define HIGH 1
#define LOW  0

void tftlcd_write_index_register(int);
void tftlcd_write_wdr(int);
int tftlcd_read_rdr(void);
void tftlcd_write_command(int,int);
void tftlcd_fill(int);
void tftlcd_fill_pic(int,int,int,const unsigned short *);
void tftlcd_clear(void);
void tftlcd_init(void);
void tftlcd_write_pixel(int,int,int);
int tftlcd_read_pixel(int,int);
void tftlcd_draw_line(int,int,int,int,int);
void tftlcd_draw_rectangle(int,int,int,int,char,int);
void tftlcd_draw_circle(int,int,int,char,int); 
void tftlcd_write_pic(int,int,const unsigned short *);
void init_lcd_for_picture(void);
void tftlcd_gotoxy(int,int);
void tftlcd_putchar(char,int,int,int);
void tftlcd_putsf(const char *,int,int,int);
void tftlcd_puts(char *,int,int,int);

#endif
